#include <bits/stdc++.h>

#define ll long long

struct Point
{
    ll x, y;
};

std::vector<std::tuple<double, Point, int>> transform(std::vector<Point>& vecs)
{
    std::vector<std::tuple<double, Point, int>> res;

    for(const Point& p : vecs)
    {
        double t1 = std::atan2(p.x, -p.y);
        double t2 = std::atan2(-p.x, p.y);

        t1 = std::fmod(t1, 2 * M_PI);
        t2 = std::fmod(t2, 2 * M_PI);

        res.push_back(std::make_tuple(t1, p, 1));
        res.push_back(std::make_tuple(t2, p, -1));
    }

    std::sort(res.begin(), res.end(), [](const auto& A, const auto& B) {
        return std::get<0>(A) < std::get<0>(B);
    });

    return res;
}

std::vector<Point> vsmer(std::vector<Point>& vecs, double ugao)
{
    double x = std::cos(ugao), y = std::sin(ugao);
    std::vector<Point> res;

    for(const Point& p : vecs)
    {
        if(p.x * x + p.y * y > 0)
            res.push_back(p);
    }

    return res;
}

std::vector<ll> vsmer2(std::vector<Point>& vecs, double ugao)
{
    double x = std::cos(ugao), y = std::sin(ugao);
    std::vector<ll> res;

    for(ll i = 0; i < vecs.size(); i++)
    {
        if(vecs[i].x * x + vecs[i].y * y > 0)
            res.push_back(i);
    }

    return res;
}

int main()
{
    ll N;
    std::cin >> N;
    
    std::vector<Point> vecs(N);
    for(ll i = 0; i < N; i++)
        std::cin >> vecs[i].x >> vecs[i].y;
    
    double nugao;
    Point tsum = { 0, 0 };
    double nnorm = 0;
    auto tvec = transform(vecs);

    for(const auto& v : tvec)
    {
        double ugao = std::get<0>(v) + 0.00000001;
        if(tsum.x == 0 && tsum.y == 0)
        {
            for(const Point& p : vsmer(vecs, ugao))
            {
                tsum.x += p.x;
                tsum.y += p.y;
            }
        }
        else
        {
            Point p = std::get<1>(v);
            int e = std::get<2>(v);
            tsum.x += p.x * e;
            tsum.y += p.y * e;
        }

        double norm = tsum.x * tsum.x + tsum.y * tsum.y;
        if(norm > nnorm)
        {
            nnorm = norm;
            nugao = ugao;
        }
    }

    std::vector<ll> res = vsmer2(vecs, nugao);
    std::cout << res.size() << "\n";
    for(const ll& i : res)
        std::cout << i + 1 << " ";

    return 0;
}